<?php
/**
 * SellingUnitOnlyPropertyImageCollection.php 2020-3-30
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Images\Entities;

use Gambio\Shop\SellingUnit\Images\Entities\Interfaces\SellingUnitImageInterface;
use Gambio\Shop\SellingUnit\Images\ValueObjects\ProductImageSource;
use Gambio\Shop\SellingUnit\Images\ValueObjects\PropertyImageSource;

/**
 * Class SellingUnitOnlyPropertyImageCollection
 * @package Gambio\Shop\SellingUnit\Images\Entities
 */
class SellingUnitOnlyPropertyImageCollection extends SellingUnitImageCollection
{
    /**
     * @inheritDoc
     */
    protected function sort(): void
    {
        parent::sort();
        
        if ($this->collectionHasProductImages() && $this->collectionHasPropertyImage()) {
        
            $this->values = array_filter($this->values, static function(SellingUnitImageInterface $image) {
                return ($image->source() instanceof ProductImageSource) === false;
            });
        }
    }
    
    
    protected function collectionHasProductImages(): bool
    {
        if (count($this)) {
    
            foreach ($this as $image) {
                
                if ($image->source() instanceof ProductImageSource) {
                    
                    return true;
                }
            }
        }
        
        return false;
    }
    
    
    protected function collectionHasPropertyImage(): bool
    {
        if (count($this)) {
        
            foreach ($this as $image) {
            
                if ($image->source() instanceof PropertyImageSource) {
                    
                    return true;
                }
            }
        }
        
        return false;
    }
}